/**
 * Script para resetar o banco de dados
 * Use quando houver problemas com a estrutura do banco
 */

const fs = require('fs');
const path = require('path');

console.log('🗑️  Resetando banco de dados...');
console.log('');

const dbPath = path.join(__dirname, '..', 'data', 'bot.db');

if (fs.existsSync(dbPath)) {
  try {
    fs.unlinkSync(dbPath);
    console.log('✅ Banco de dados antigo removido');
  } catch (error) {
    console.error('❌ Erro ao remover banco:', error.message);
    console.log('');
    console.log('💡 Tente fechar o bot e executar novamente');
    process.exit(1);
  }
} else {
  console.log('ℹ️  Banco de dados não existe');
}

console.log('');
console.log('✅ Reset completo!');
console.log('');
console.log('🚀 Execute: npm start');
console.log('   O banco será recriado automaticamente');
console.log('');
